/*
Author: Radek Henys (admin@mouseviator.com)
Version: 1.0b
Last update: 26.3.2014
License: LGPL v3
*/

#include "common.h"

/*
	This is helper function that is used in other functions to throw an error with message back to lua script.

	Parameters:
		None.
*/
int getLastError(lua_State *L) {
	DWORD errorCode;
	//get last error for generated by windows API
	errorCode = GetLastError();
	char* errorMessage;

	//get the error message
	FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM
		// allocate buffer on local heap for error text
		| FORMAT_MESSAGE_ALLOCATE_BUFFER
		// Important! will fail otherwise, since we're not 
		// (and CANNOT) pass insertion parameters
		| FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,    // unused with FORMAT_MESSAGE_FROM_SYSTEM
		errorCode,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
		(LPTSTR)&errorMessage,  // output 
		0,	// minimum size for output buffer
		NULL);   // arguments - none

	if (errorMessage != NULL) {
		lua_pushfstring(L, "Error; code: %d ,message: %s", errorCode, errorMessage);
		//free memory used for error message
		LocalFree(errorMessage);
		errorMessage = NULL;
		return lua_error(L);
	}
	else {
		//return an error
		return luaL_error(L, "Error; code: %d ,message: Failed to get error message!!!", errorCode);
	}
}


/*
	This function will return title for window specified by handle.

	Parameters:
		nWnd - handle to window we want to get title for.
	Returns:
		String with the text of specified window or empty string.
*/
std::string getWindowText(HWND hWnd) {
	std::string text;
	//get the length of window text
	int length = GetWindowTextLength(hWnd);
	if (length > 0) {
		/*LPSTR pszText = (LPSTR)GlobalAlloc(GPTR, length + 1);
		if (pszText != NULL)
		{
		if (GetWindowText((HWND)(LONG_PTR)hWnd, pszText, length + 1))
		{
		lua_pushstring(L, pszText);
		}
		GlobalFree(pszText);
		}
		else {
		lua_pushnil(L);
		}*/
		TCHAR* buffer = new TCHAR[length + 1];
		if (GetWindowText((HWND)(LONG_PTR)hWnd, buffer, length + 1)) {
			text.append(buffer);
		}
		delete[] buffer;
	}
	return text;
}